package gui.menus.view;
import gui.GenericLoader;
import gui.GraphViewerPanel;
import gui.MainFrame;
import gui.jtransitionsystem.JTransitionSystemComposed;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import service.ComposedTransition;
import service.ComposedState;
import service.TransitionSystem;

/**
 * @author Andrea
 *
 */
public class CartProdItem extends JMenuItem
{

	private static final long serialVersionUID = 1L;

	public CartProdItem()
	{
		super();
		init();
	}
	
	void init()
	{
		this.setText("View Cartesian Product");
		
		this.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				if(!GenericLoader.orchestratorIsStarted()){
					JOptionPane.showMessageDialog(MainFrame.getInstance(), "Orchestrator not started", "Warning", JOptionPane.WARNING_MESSAGE);
					return;
				}	
				try
				{
					if(GenericLoader.getAsyncProduct().getAllStates().size() >=20)
					{
						int optionSelected = JOptionPane.showConfirmDialog(null, "Warning! You have selected to show the Cartesian Product of the entire Simulation.\n It has size:\n"+ GenericLoader.getAsyncProduct().getAllStates().size()+" nodes\n"+GenericLoader.getAsyncProduct().getAllActions().size()+" edges\nVisualization could be very slow.\n Are you sure you want to visualize it anyway?", "Warning", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
						if(optionSelected == JOptionPane.YES_OPTION)
						{
							TransitionSystem<ComposedState, ComposedTransition> asyncProduct = GenericLoader.getAsyncProduct();
							JTransitionSystemComposed jAsyncProduct = new JTransitionSystemComposed(asyncProduct);
							GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
							
							graphPanel.printGraph(jAsyncProduct.getVisualizationViewer());
							graphPanel.setGraphName("Cartesian Product");
							
						}
					
						else
						{
							JOptionPane.showMessageDialog(MainFrame.getInstance(), "You are a very wise person ;)");
						}
					}
					else
					{
						TransitionSystem<ComposedState, ComposedTransition> asyncProduct = GenericLoader.getAsyncProduct();
						JTransitionSystemComposed jAsyncProduct = new JTransitionSystemComposed(asyncProduct);
						GraphViewerPanel graphPanel = MainFrame.getInstance().getGraphViewerPanel();
						
						graphPanel.printGraph(jAsyncProduct.getVisualizationViewer());
						graphPanel.setGraphName("Cartesian Product");
						
					}
				}
				catch(Exception ex)
				{
					JOptionPane.showMessageDialog(null, "Error: "+ex.getMessage(),"Error", JOptionPane.ERROR_MESSAGE);
				}
			}
		});
	}
}
